package labirinto.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

import labirinto.VictoryException;
import labirinto.tests.LabirintoGame;

public class VictoryDialog extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public VictoryDialog(VictoryException exception) {
		super(LabirintoGame.getFrame(), true);
		setSize(200, 200);
		setLayout(new GridLayout(1, 1));
		getContentPane().add(new JLabel(exception.getMessage()),BorderLayout.CENTER);
		// System.exit(0);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((int) (dim.getWidth() - getWidth()) / 2,
				(int) (dim.getHeight() - getHeight()) / 2);
		((JFrame) LabirintoGame.getFrame()).setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

}